import React, { useEffect, useState } from 'react'
import { Card, CardBody, CardFooter, Table, Alert, FormGroup } from "reactstrap";
import FalconCardHeader from '../common/FalconCardHeader';
import config from '../../helpers/config';
import { useParams } from 'react-router-dom';
import axios from 'axios';

const Shortlist = ({ title }) => {
    const { id } = useParams()
    const dataNotFound = true;
    const [ShortListCandidate, setShortResData] = useState([
        // {
        //     title : 'Check List',
        //     name : "d",
        //     email : "d",
        //     phone: "sd",
        //     status : "D"
        // }
    ]);


    const reqData = new FormData();
    reqData.append('companyID', '11118');

    axios.post({
        url: `${process.env.REACT_APP_API_URL}/company/shortlistCandidate`,
        data: reqData,
        headers: { "Content-Type": "multipart/form-data" }
    }).then(res => {
        console.log('sucessfully worked shortlist API');
        if (res) {
            dataNotFound = false;
            setShortResData(res.data);
        }
    }).catch(err => {
        console.log('Shortlist API is not sucessfuly worked', err)
    })

    return (
        <Card className="mb-3">
            <FalconCardHeader title={title} />

            <CardBody className="text-justify">
                <div className="table-responsive">
                    <style jsx>{`
              th {
                font-size: 12px;
                
              }
              tr td {
                color: black;
              }
              
            `}</style>


                    <Table className="table table-striped table-sm table" style={{ tableLayout: "auto", width: "100%" }} >
                        <thead>
                            <tr style={{ fontSize: "12px", textTransform: "uppercase", color: "black" }}>
                                <th>Job Title</th>
                                <th>Candidate</th>
                                <th>Cand. Email</th>
                                <th>Phone</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        {
                            dataNotFound &&

                            <tbody>
                                <tr>
                                    <td> Minus consequatur do </td>
                                    <td> Tempora odit distinc </td>
                                    <td> candi@mailinator.com </td>
                                    <td> NA </td>
                                    <td> Shortlist </td>
                                </tr>
                                <tr>
                                    <td> Minus consequatur do </td>
                                    <td> Et sint provident </td>
                                    <td> dororowel@mailinator.com </td>
                                    <td> NA </td>
                                    <td> Shortlist </td>
                                </tr>
                            </tbody>
                        }
                        {
                            !dataNotFound &&

                            <tbody>
                                {
                                    ShortListCandidate.length > 0 ?
                                        (ShortListCandidate.map((candidate, index) => (
                                            <tr key={index}>
                                                <td>{candidate.title ? candidate.title : null}</td>
                                                <td>{candidate.name ? candidate.name : null}</td>
                                                <td>{candidate.email ? candidate.email : null}</td>
                                                <td>{candidate.phone ? candidate.phone : "NA"}</td>
                                                <td>{candidate.status ? candidate.status : null}</td>
                                            </tr>
                                        ))) : (
                                            <tr className="danger">
                                                <td colspan="7" style={{ padding: "2px 0" }}>
                                                    <Alert color="danger">No Cerification Found</Alert>
                                                </td>
                                            </tr>
                                        )
                                }
                            </tbody>
                        }

                        <tfoot />
                    </Table>

                </div>
            </CardBody>

            <CardFooter className="bg-light p-0 border-top">

            </CardFooter>
        </Card>
    )
}
export default Shortlist;