import React,{useState} from 'react'
import {Card, CardBody, Row, Col, Table, Button, Input, Badge} from "reactstrap"
import './UserRole.css'


const EditorContent = ({data}) => {
	const [showAdmin, setShowAdmin] = useState(true)
	const [search, setSearch] = useState('')

	const onClickAdmin = () => {
		setShowAdmin(!showAdmin)
	}
	const editor = data?.filter(data => data.role_id === 10)
	// console.log(editor,"editorsss")
	// console.log(search,"search")

    return (
        
        		<Table bordered className="user__role__table">
      
        			<thead>
        				<tr>
							<th></th>
							<th></th>
							<th colSpan="2">
								<Input 
									type="text" 
									placeholder="Search for names..." 
									className="header_input"
									onChange={e => setSearch(e.target.value)}
									value={search}
								/>
							</th>
						</tr>
						<tr>
							<th className="col-md-6">Name</th>
							<th>Email</th>
							<th>Role</th>
							<th>Status</th>
						</tr>

					</thead>
					<tbody>
						{editor && editor?.filter(val => {
							if(search == ""){
								return val
							}else if(val.name.toLowerCase().includes(search.toLowerCase())){
								return val
							}
						}).map((data, index) => (
								<tr key={index}>
									<td key={data.name}>{data.name}</td>
									<td key={data.email}>{data.email}</td>
									<td key={index}>{data.role}</td>
									<td key={"keyshere"}>
										{
											data?.accepted === 0 
												? 
											<h5>
												<Badge color="info" pill>Pending</Badge>
											</h5>
												: 
											data?.accepted === 2 
												? 
											<h5>
												<Badge color="danger" pill>Rejected</Badge>
											</h5>
												: 
											<h5>
												<Badge color="success" pill>Accepted</Badge>
											</h5>
										}
									</td>
								</tr>		

						))}
				</tbody>
				<tfoot/>
        		</Table>
        	
    )
}

export default EditorContent
