import React,{useState} from 'react'
import {Card, CardBody, Row, Col, Table, Button, Input, Badge} from "reactstrap"
import './UserRole.css'


const RecruiterContent = ({data}) => {
	const [showAdmin, setShowAdmin] = useState(true)
	const [search, setSearch] = useState('')

	const onClickAdmin = () => {
		setShowAdmin(!showAdmin)
	}
	const recruiter = data?.filter(data => data.role_id === 11)

    return (
        
        		<Table bordered className="user__role__table">
      
        			<thead>
      					<tr>
							<th></th>
							<th></th>
							<th colSpan="2"><Input 
									type="text" 
									placeholder="Search for names..." 
									className="header_input"
									onChange={e => setSearch(e.target.value)}
									value={search}
								/>
							</th>
						</tr>
						<tr>
							<th>Name</th>
							<th>Email</th>
							<th>Role</th>
							<th>Status</th>
						</tr>

					</thead>
					<tbody>
						{recruiter && recruiter?.filter(val => {
							if(search == ""){
								return val
							}else if(val.name.toLowerCase().includes(search.toLowerCase())){
								return val
							}
						}).map(data => (
						   
								<tr>
									<td>{data.name}</td>
									<td>{data.email}</td>
									<td>{data.role}</td>
									<td>
										{
											data?.accepted === 0 
												? 
											<h5>
												<Badge color="info" pill>Pending</Badge>
											</h5>
												: 
											data?.accepted === 2 
												? 
											<h5>
												<Badge color="danger" pill>Rejected</Badge>
											</h5>
												: 
											<h5>
												<Badge color="success" pill>Accepted</Badge>
											</h5>
										}
									</td>
								</tr>		
							

						))}
				</tbody>
				<tfoot/>
        		</Table>
        	
    )
}

export default RecruiterContent
