import React, { useState, useEffect  } from "react";
import {
  Card,
  CardBody,
  Row,
  Col,
  Table,
  Button,
  Badge,
  Input,
  Form,
  FormGroup,
  Label,
  Container,
} from "reactstrap";
import "./UserRole.css";
import AdminContent from "./AdminContent";
import EditorContent from "./EditorContent";
import RecruiterContent from "./RecruiterContent.js";
import JobManagerContent from "./JobManagerContent.js";
import PrivateCertifierContent from "./PrivateCertifierContent.js";
import Modal from "react-awesome-modal";
import axios from "axios";
import correct from "../../../assets/img/icons/correct.gif";
import warning from "../../../assets/img/icons/warn.png";
import AsyncSelect from 'react-select/async'
import { ReactSearchAutocomplete } from 'react-search-autocomplete';
import spinner from '../../../assets/img/media/spinner.gif'


// import InviteUserForm from './InviteUserForm'
// import {useParams} from 'react-router-dom';

const UserRole = (props) => {


  const pathname = window.location.pathname
  const company_id = pathname.slice(-5)
  const [showAdmin, setShowAdmin] = useState(true);
  const [showEditor, setShowEditor] = useState(false);
  const [showRecruiter, setShowRecruiter] = useState(false);
  const [showJobManager, setShowJobManager] = useState(false);
  const [showPrivateCertifier, setShowPrivateCertifier] = useState(false);
  const [isModalOpen, setModalOpen] = useState(false);
  const [isModalTwoOpen, setModalTwoOpen] = useState(false);
  const [inviteData, setInviteData] = useState(false);
  const [showWarningImg, setShowWarningImg] = useState(false);
  const [userRoleData, setUserRoleData] = useState(null);
  // const [userList, setUserList] = useState(null);
  const [isLoading, setIsLoading] = useState(false)
  const [selectValue, setSelectValue] = useState({})
  const [selectedOption, setSelectedOption] = useState({})

  
  const [formData, setFormData] = useState({
    name:'',
    email:'',
    role:'9'
  })
  const { name, email, role } = formData;

// const filtered = userList?.map((item, index) => {
//     return{
//       ["id"]: item.id,
//       ["name"]: [item.user_f_name, item.user_l_name].toString().replace(","," ") ,
//       ["email"]: item.user_email
//     }
//   })
// console.log(filtered)

// const filteredSelect = userList?.map((item, index) => {
//     return{
//       ["value"]: item.user_f_name || item.user_l_name,
//       ["label"]: item.user_f_name || item.user_l_name,
//       ["email"]: item.user_email
//     }
//   })

// function customTheme(theme){
//   return{
//     ...theme,
//     colors: {
//       ...theme.colors,
//       primary25:"orange",
//       primary:"green"
//     }
//   }
// }
  const onClickAdmin = () => {
    setShowAdmin(true);
    setShowEditor(false);
    setShowRecruiter(false);
    setShowJobManager(false);
    setShowPrivateCertifier(false);
  };
  const onClickEditor = () => {
    setShowEditor(true);
    setShowAdmin(false);
    setShowRecruiter(false);
    setShowJobManager(false);
    setShowPrivateCertifier(false);
  };

  const onClickRecruiter = () => {
    setShowRecruiter(true);
    setShowEditor(false);
    setShowAdmin(false);
    setShowEditor(false);
    setShowJobManager(false);
    setShowPrivateCertifier(false);
  };
  const onClickJobManager = () => {
    setShowJobManager(true);
    setShowRecruiter(false);
    setShowEditor(false);
    setShowAdmin(false);
    setShowEditor(false);
    setShowPrivateCertifier(false);
  };

  const onClickPrivateCertifier = () => {
    setShowPrivateCertifier(true);
    setShowJobManager(false);
    setShowRecruiter(false);
    setShowEditor(false);
    setShowAdmin(false);
    setShowEditor(false);
  };
  const inviteUserModal = () => {
    setModalOpen(true);
  };

  const closeModal = () => {
    setModalOpen(false);
  };
  const style = {};

  // useEffect(() => {
  //   axios.get('http://13.49.154.94/backend/api/v2/user/getuserlist?offset=0&limit=10&search=' + name)
  //     .then(res => {
  //       if(res?.status === 200) {
  //         setUserList(res?.data?.result?.data)

  //       }
  //     })
  //     .catch(err => console.log(err))
  // },[name])


  useEffect(() => {
    axios.post(`${process.env.REACT_APP_API_URL}/company/joined_candidate_list` + "?" + "default_user="
      + localStorage.getItem('default_user') + "&company_id=" + company_id)
    .then(res => {
      // console.log(res,"this is res")
      if(res?.status === 200){
          setUserRoleData(res?.data?.candidate_list)
      }

  })
    .catch(err => console.log(err))
  },[isModalTwoOpen])
// console.log(userRoleData,"userRoleData")
  
  let bodyFormData = new FormData();

  const inviteUserHandler = (e) => {
    e.preventDefault()
    setIsLoading(true)

    // console.log(formData,"Invite USER")
    bodyFormData.append('default_user', localStorage.getItem('default_user'));
      bodyFormData.append('company_id', company_id);
      bodyFormData.append('invited_for', role);
      bodyFormData.append('name', name);
      bodyFormData.append('email', email);

      axios({
        method: 'post',
        url: `${process.env.REACT_APP_API_URL}/company/sendmail`,
        data: bodyFormData,
        headers: {'Content-Type': 'multipart/form-data' }
      })
      .then(function (response) {
        if(response.status === 200){
        // console.log(response,"after res")
        setModalOpen(false)
        setModalTwoOpen(true)
        if(response?.data?.msg == "This user already invited."){
          // console.log(response.data,"wronggggggggggggggggg")
          setShowWarningImg(true)
        }
        if(response?.data?.msg == "You can not invite your self."){
          setShowWarningImg(true)
        }
          setInviteData(response?.data?.msg)
        setFormData({
          name:'',
          email:''
        })

        setTimeout(() => {
          setModalTwoOpen(false)
        setShowWarningImg(false)
        setIsLoading(false)
        },2000)
      }

      })
      .catch(err => console.log(err))
    

  }
  // console.log(isLoading,"isLoading")
const onChangeHandler = (e) => {
    setFormData({...formData, [e.target.name]: e.target.value})
  }




  // const handleOnSearch = (string, results) => {
  //   // console.log(string,"stringstring")
  //   // console.log(results,"resultsresults")
  //   setUserList(results)
  //   setFormData({
  //     ...formData,
  //     name: string
  //   })
    

  // }

  // const handleOnSelect = (item) => {
  //   setFormData({
  //     ...formData,
  //     name: item.name.toString().replace(',',''),
  //     email: item.email
  //   })
  //   // console.log(item,"handleOnSelect")
  // }

  // const handleOnFocus = () => {
  //   // console.log('Focused')
  // }

  

  // // console.log(formData,"formData")

const fetchData = (inputValue, callback) => {
  // console.log(inputValue)
  if(!inputValue){
    callback([])
  }else{
    setTimeout(() => {
      axios.get(`${process.env.REACT_APP_API_URL}/user/getuserlist?offset=0&limit=10&search=` + inputValue)
        .then(resp => {
          const tempArray = [];
         resp.data.result.data.map(item => tempArray.push({
          label: `${item.user_f_name} ${item.user_l_name}`, value: `${item.user_email}`
         }))   
         // console.log(tempArray,"tempArray")
         callback(tempArray)
        })
        .catch(err => console.log(err))
    },1000)
  }
}

const onSearchChange = (selectedOption) => {
// console.log(selectedOption)
if(selectedOption){
  setSelectedOption(selectedOption)
  setFormData({...formData, name: selectedOption.label, email: selectedOption.value})
}

}

  return (
    <>
    <Modal
          visible={isModalTwoOpen}
          width="400" height="300"
          effect="fadeInUp"
          onClickAway={() => closeModal()}
        >
        <div style={{textAlign:"center"}}>
            <img src={showWarningImg == true ? warning : correct}  width="200px" style={{marginTop:'10px', textAlign:'center'}}/>

            <h4>{inviteData}</h4>
        </div>
        </Modal>

      {isModalOpen && (
        <Modal
          visible={isModalOpen}
          width="500"
          height="450"
          effect="fadeInUp"
          onClickAway={() => closeModal()}
        >
          <div>
            <p className="modal_header">Invite User</p>
            <hr />
            <div>
              <Container>
              
                 <Form onSubmit={e => inviteUserHandler(e)}>
                    <FormGroup>
                      <Label for="name">Name</Label>



                      <AsyncSelect
                        onChange={e => onSearchChange(e)}
                        value={selectedOption}
                        defaultOptions={false}
                        cacheOptions
                        isClearable
                        className="basic-single"
                        classNamePrefix="select"
                        name="search"
                        loadOptions={fetchData}
                      />




                    </FormGroup>
                    <FormGroup>
                      <Label for="email">Email</Label>
                      <Input type="text" name="email" id="email" placeholder="Email" value={email} onChange={e => onChangeHandler(e)} disabled/>
                     
                    </FormGroup>  


                    <FormGroup>
                      <Label for="role">Role</Label>
                      <Input type="select" name="role" id="role" onChange={e => onChangeHandler(e)} value={role}>
                          <option value="">Select Role</option>
                          <option value="9">Admin</option>
                          <option value="10">Editor</option>
                          <option value="11">Recruiter</option>
                          <option value="12">Job Manager</option>
                          <option value="13">Private Certifier</option>
                      </Input>
                    </FormGroup>
                    <div style={{textAlign:'end'}}>
                    {isLoading 
                      ? 
                      <Badge className="spinner-btn" color="light"><img src={spinner} width="30px"/></Badge>
                      
                      : 
                      (
                        <Button disabled={email == "" ? true : false} type="submit" color="primary" style={{marginRight:'10px'}} >Invite</Button>
                      )}
                        <Button onClick={closeModal} >Cancel</Button>
                    </div>
                  </Form> 
              </Container>
            </div>
          </div>
        </Modal>
      )}
      <Card>
        <CardBody>
          <Row>
            <Col md="4">
              <Table bordered size="lg" responsive>
                <thead>
                  <tr>
                    <th className="table_Header">Company User Roles</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td
                      className={showAdmin ? "table_data_active" : "table_data"}
                      onClick={onClickAdmin}
                    >
                      Admin

                    </td>
                  </tr>
                  <tr>
                    <td
                      className={
                        showEditor ? "table_data_active" : "table_data"
                      }
                      onClick={onClickEditor}
                    >
                      Editor
                    </td>
                  </tr>
                  <tr>
                    <td
                      className={
                        showRecruiter ? "table_data_active" : "table_data"
                      }
                      onClick={onClickRecruiter}
                    >
                      Recruiter
                    </td>
                  </tr>
                  <tr>
                    <td
                      className={
                        showJobManager ? "table_data_active" : "table_data"
                      }
                      onClick={onClickJobManager}
                    >
                      Job Manager
                    </td>
                  </tr>
                  <tr>
                    <td
                      className={
                        showPrivateCertifier
                          ? "table_data_active"
                          : "table_data"
                      }
                      onClick={onClickPrivateCertifier}
                    >
                      Private Certifier
                    </td>
                  </tr>
                </tbody>
                <tfoot />
              </Table>
            </Col>
            <Col md="8" className="right_section">
              <Button color="primary" size="lg" onClick={inviteUserModal}>
                Invite User
              </Button>
              <hr />
              {showAdmin && <AdminContent data={userRoleData}/>}
              {showEditor && <EditorContent data={userRoleData}/>}
              {showRecruiter && <RecruiterContent data={userRoleData}/>}
              {showJobManager && <JobManagerContent data={userRoleData}/>}
              {showPrivateCertifier && <PrivateCertifierContent data={userRoleData}/>}
            </Col>
          </Row>
        </CardBody>
      </Card>
    </>
  );
};

export default UserRole;
