import React,{useContext} from 'react'
import { Card, CardBody, CardFooter, Row, Col, Input, Table} from "reactstrap";
import FalconCardHeader from '../../common/FalconCardHeader';
import {Associations} from '../PrivateCertifierDetailsPage'
import {AllDetailsContext} from '../../AllDetailsContext/AllDetailsContext'

const AssignedCandidate = ({title, data}) => {
	// console.log(data,"dddddddddddsssssss")
	const {companyData} = useContext(AllDetailsContext)

	return(
		<>
		<Card className="mb-3">
      <FalconCardHeader title={title} />

      <CardBody className="text-justify">
      <div>
        <Row>
        	<Col md="4" className="mb-3">
        		<Input type="select" defaultValue="Select">
        			{companyData?.userCompanies?.map(company => (
        				<option key={company.id}>{company.company_name}</option>
        				))}
        		</Input>
        	</Col>
        	<Col md="4">
        		<Input type="select" placeholder="Select Certification Rating">
        			<option>Select Certification Rating</option>
        			<option>1</option>
        			<option>2</option>
        			<option>3</option>
        			<option>4</option>
        			<option>5</option>
        		</Input>
        	</Col>
        	<Col md="4"><Input type="text" placeholder="Type candidate name"/></Col>
        </Row>
        <Row>
        	<Col md="4">
        		<Input type="select">
        			<option>Select Skills</option>
        			<option>Angular</option>
        			<option>Ionic</option>
        			<option>Node</option>
        			
        		</Input>
        	</Col>
        	<Col md="4">
        		<Input type="select">
        			<option>Select Current Employer</option>
        			<option>Angular Developer</option>
        			<option>Ionic Developer</option>
        			<option>Node Backend</option>
        		</Input>
        	</Col>
        	<Col md="4">
        		<Input type="select">
        			<option>Select Reccom.</option>
        			<option>Test 1</option>
        			<option>Test 2</option>
        			<option>Test 3</option>
        		</Input>
        	</Col>
        </Row>
        </div>
        <div>
        	<Table >
        		<thead>
        			<tr className="d-flex flex-row justify-content-center align-items-center">
        				<th>Date</th>
        				<th>Rec. Company</th>
        				<th>Certification</th>
        				<th>Candiate Name</th>
        				<th>Top Skills</th>
        				<th>Assign Certifier</th>

        			</tr>
        		</thead>
        		<tbody>
        			<tr className="d-flex flex-row justify-content-center align-items-center">
        				<td>No Data Found!!!</td>
        			</tr>
        		</tbody>
        		<tfoot/>
        	</Table>
        </div>
      </CardBody>

      <CardFooter className="bg-light p-0 border-top">
        
      </CardFooter>
    </Card>
    <Associations/>
    </>
		)
}
export default AssignedCandidate