import React from 'react'
import { Card, CardBody, CardFooter, Row, Col} from "reactstrap";
import FalconCardHeader from '../../common/FalconCardHeader';
import {Associations} from '../PrivateCertifierDetailsPage'
import './privateCertifier.css'

const CertifierAddress = ({title, data}) => {
	// console.log(data,"dddddddddddsssssss")
	return(
		<>
		<Card className="mb-3">
      <FalconCardHeader title={title} />

      <CardBody className="text-justify">
        <Row className="mb-2">
        	<Col md="2">Address :</Col>
        	<Col className="col-val">{data.address}</Col>
        </Row>
        <Row className="mb-2">
        	<Col md="2">Pincode :</Col>
        	<Col className="col-val">{data.pincode}</Col>
        </Row>
        <Row className="mb-2">
        	<Col md="2">Phone :</Col>
        	<Col className="col-val">{data.phone}</Col>
        </Row>
        <Row className="mb-2">
        	<Col md="2">Email :</Col>
        	<Col className="col-val">{data.email}</Col>
        </Row>
      </CardBody>

      <CardFooter className="bg-light p-0 border-top">
        
      </CardFooter>
    </Card>
    <Associations/>
    </>
		)
}
export default CertifierAddress