import React from 'react'
import { Card, CardBody, CardFooter, Row, Col} from "reactstrap";
import FalconCardHeader from '../../common/FalconCardHeader';
import {Associations} from '../PrivateCertifierDetailsPage'
import './privateCertifier.css'


const CompanyInfo = ({title, data}) => {
	return(
		<>
		<Card className="mb-3">
      <FalconCardHeader title={title} />

      <CardBody className="text-justify">
        <Row className="mb-2">
        	<Col md="3">Company Name :</Col>
        	<Col className="col-val">{data.company_info}</Col>
        </Row>
        <Row className="mb-2">
        	<Col md="4">Number of Employees :</Col>
        	<Col className="col-val">{data.number_of_emp}</Col>
        </Row>
        <Row className="mb-2">
        	<Col md="3">Year of Establish :</Col>
        	<Col className="col-val">{data.year_of_establish}</Col>
        </Row>
        
      </CardBody>

      <CardFooter className="bg-light p-0 border-top">
        
      </CardFooter>
    </Card>
    <Associations/>
    </>
		)
}
export default CompanyInfo