import React,{useEffect, useState, useRef} from 'react';
import { Card, CardBody, CardFooter, Row, Col, Container,Table,Button,Form,FormGroup,Label,Input, Badge, Alert} from "reactstrap";
import FalconCardHeader from '../../common/FalconCardHeader';
import axios from 'axios';
// import usePostFetch from "../../../hooks/usePostFetch";
import config from '../../../helpers/config';
import { toast } from 'react-toastify';
import {useHistory} from 'react-router-dom';
import './privateCertifier.css'
// import {toast} from 'react-toastify';




const GiveCertification = (props) => {
	console.log(props,"dddddddddddddddd")
	const [fetchedSkills, setFetchedSkills] = useState(null)
	const [isAddSkill, setIsAddSkill] = useState(false)
	const [showBtn, setShowBtn] = useState(true)
	const [reload, setReload] = useState(false)
	const [userSkill, setUserSkill] = useState([])
	const [allSkill, setAllSkill] = useState([])
	
	const [addedSkill, setAddedSkill] = useState({
		skill_id:'',
		skill_name:'',
		rating:'',
		explanation:''
	})
	
	const skillRef = useRef()
	const history = useHistory()
	
	// console.log(skillRef.getRef(),"skillRef")
	
	useEffect(() => {
		if(allSkill.length >= 5){
			toast.error('You can certify only upto 5 skills!')
			setShowBtn(true)
		}else{
			setShowBtn(false)
		}
	},[addedSkill.skill_name,addedSkill.skill_id, addedSkill.rating, addedSkill.explanation, reload])

	useEffect(() => {
		if(addedSkill.skill_name && addedSkill.rating && addedSkill.explanation){
			setShowBtn(false)
		}else{
			setShowBtn(true)
		}

	},[addedSkill.skill_name, addedSkill.rating, addedSkill.explanation])
	
	console.log(allSkill,"showBtn")
	useEffect(() => {
		const skillBody = new FormData()
		skillBody.append('user_id', props?.location?.state?.data?.candidate_id)
		axios({
			method:'post',
			url:`${process.env.REACT_APP_API_URL}/get_selected_skills`,
			data:skillBody,
			headers:{
				'Content-Type':'multipart/form-data'
			}
		})
		.then(res => {
			if(res?.data?.result?.data?.status === true){
				setFetchedSkills(res?.data?.result?.data)
			}
			
		})
		.catch(err => console.log(err))
	},[])
	console.log(fetchedSkills,"userSkills=========")
	console.log(addedSkill,"addedSkill")
	
	const user_detail = props?.location?.state?.data;

	
	
	const onChangeInput= e => {
		console.log(e.target.value)
		const filterSkill = fetchedSkills?.selected_skill?.filter(skill => skill.id == e.target.value)
		console.log(filterSkill,"filterSkill")
		// setAddedSkill([...addedSkill, filterSkill[0]])
		setAddedSkill({...addedSkill, skill_id: filterSkill[0].id, skill_name:filterSkill[0].skill_name})
	}
	const onChangeInputRating = e => {
		setAddedSkill({...addedSkill, rating:e.target.value})
	}
	const onChangeInputExplanation = e => {
		setAddedSkill({...addedSkill, explanation:e.target.value})
	}

	// ============ ADD SKILL =================
	const addSkillHandler = () => {
		setAllSkill([...allSkill, addedSkill])
		setAddedSkill({
			skill_id:'',
			skill_name:'',
			rating:'',
			explanation:''
		})
	}
	const deleteItem = index => {
		console.log(index,"skill_id")
		const newSkill = allSkill?.filter((skill, id) => id !== index)
		console.log(allSkill,"allSkillallSkillallSkill")
		setAllSkill(newSkill)
		setReload(!reload)

	}

	function removeduplicates(arr){
		const uniqueIds = [];
		if(Array.isArray(arr)){
		  // console.log('1',Array.isArray(arr))
		  const unique = arr.filter(element => {
			const isDuplicate = uniqueIds.includes(element.id);
		
			if (!isDuplicate) {
			  uniqueIds.push(element.id);
			  return true;
			}
			return false;
			});
			return unique;
		}
		
	  }


	const onSubmitSkill = e => {
		e.preventDefault()
		console.log(allSkill,'ddddddddddd')

	
		const formBody = new FormData()

		formBody.append('default_user', localStorage.getItem('default_user'))
		formBody.append('candidate_id', user_detail?.candidate_id)
		formBody.append('company_id', user_detail?.company_id)
		formBody.append('skills', JSON.stringify({allSkill}))

		axios({
			method:'post',
			url:`${process.env.REACT_APP_API_URL}/company/certify-the-candidate`,
			data: formBody,
			headers:{
				'Content-Type':'multipart/form-data'
			}
		})
		.then(res => {
			console.log(res,"==========aaa===========")
			if(res?.data?.result?.data?.status == true){
				toast.success(res?.data?.result?.data?.message)
				history.goBack()
			}
			if(res?.data?.result?.data?.status == false){
				toast.error(res?.data?.result?.data?.message)
				history.goBack()
			}
		})
		.catch(err => console.log(err))
		
	}	
return(
		<>
			<Card className="mb-3">
		      <FalconCardHeader title={"Certifying User"} />
		      <CardBody>
		      <Row>
		      	<Col md="3">Candidate Name:</Col>
		      	<Col md="9">{user_detail?.candidate?.user_f_name} {user_detail?.candidate?.user_l_name}</Col>
		      </Row>
		      <Row>
		      	<Col md="3">Email:</Col>
		      	<Col md="9">{user_detail?.candidate?.user_email}</Col>
		      </Row>
		      <Form onSubmit={onSubmitSkill}>
		      <Row style={{"marginBottom":"20px"}}>
		      	<Col md="3">
		      		<Input
		      			type="select"
		      			onChange={onChangeInput}
		      			placeholder="Add Skill"
		      			ref={skillRef}
		      		>
		      		{removeduplicates(fetchedSkills?.selected_skill)?.map((skill, index) => (
		      			<option value={skill.id} key={index}>{skill.skill_name}</option>
		      		))}
		      		</Input>
		      	</Col>
		      	<Col md="2">
		      		<Input
		      			type="select"
		      			onChange={onChangeInputRating}
		      			placeholder="Rating"
		      		>
		      			<option value="1">1</option>
		      			<option value="2">2</option>
		      			<option value="3">3</option>
		      			<option value="4">4</option>
		      			<option value="5">5</option>
		      		</Input>
		      	</Col>
		      	<Col md="4">
		      		<Input
		      			type="text"
		      			onChange={onChangeInputExplanation}
		      			placeholder="Explanation"
		      		/>
		      			
		      	</Col>
		      	<Col md="3">
		      		<Button 
		      			color='success'
		      			onClick={addSkillHandler}
		      			disabled={showBtn}
		      		>Add Skill</Button>
		      	</Col>
		      </Row>
		      
		      {allSkill && allSkill?.map((skill, index) => (
		      	<Row key={index} className="d-flex flex-row justify-content-center align-items-center added__skill">
		      		<Col md="3">Skill: {skill.skill_name}</Col>		
		      		<Col md="2">Rating: {skill.rating}</Col>		
		      		<Col md="5">Explanation: {skill.explanation}</Col>		
		      		<Col 
		      			md="2" 
		      			className="text-right"
		      			onClick={e => deleteItem(index)}
		      		><span style={{cursor:'pointer'}}>X</span></Col>		
		      	</Row>
		      ))}
		      <Row>
		      	<Button 
		      		type="submit"
		      		color="primary"
		      	>Submit</Button>
		      </Row>
		      </Form>	
		      	
		      </CardBody>
		    </Card>

		</>
		)
}
export default GiveCertification;