import React,{useEffect, useState} from 'react'
import { Card, CardBody, CardFooter, Row, Col, Container,Button, Badge, Alert} from "reactstrap";
import FalconCardHeader from '../../common/FalconCardHeader';
import {Associations} from '../PrivateCertifierDetailsPage'
import './privateCertifier.css';
import axios from 'axios';
import config from '../../../helpers/config';
import {useParams, Link} from 'react-router-dom';
import { toast } from 'react-toastify';
import Loader from '../../common/Loader';
import moment from 'moment';




const HireRequest = ({title, data}) => {

	const [hirePendingReq, setHirePendingReq] = useState(null)
	const [loading, setLoading] = useState(true)
	const [reload, setReload] = useState(0)

	const {id} = useParams()

	const hireRequest = async () => {
		const formBody = new FormData();
		formBody.append("default_user", localStorage.getItem('default_user'))
		formBody.append("private_certifier_id", data?.id)
		
		axios({
			method:'post',
			url: `${process.env.REACT_APP_API_URL}/company/private_certifer/who_send_the_invitation`,
			data: formBody,
    		headers: { "Content-Type": "multipart/form-data" },
		})
		.then(res => {
			if(res?.data?.status_code === 200){
				console.log(res)
				setHirePendingReq(res?.data?.result?.data?.invitation_list)
				setLoading(false)
			}
		})
		.catch(err => console.log(err))

		// const hire = await axios.post(`${config.API_URL()}company/private_certifer/who_send_the_invitation`)
	}
	useEffect(() => {
		hireRequest()
	},[reload])
	console.log(hirePendingReq,"hireRequest")

	const acceptHandler = (id) => {
		console.log(id)
		const formAccept = new FormData();
		formAccept.append("default_user", localStorage.getItem('default_user'))
		formAccept.append("invitation_id", id)
		formAccept.append("accept", "yes")
		axios({
			method:'post',
			url: `${process.env.REACT_APP_API_URL}/company/private_certifer/accept_reject_invitation`,
			data: formAccept,
    		headers: { "Content-Type": "multipart/form-data" },
		})
		.then(res => {
				console.log(res)
			if(res?.data?.resultType == "S"){
				toast.success("Invitation Accepted")
				setReload(1)
			}
		})
		.catch(err => console.log(err))
	}

	const rejectHandler = (id) => {
		console.log(id)
		const formAccept = new FormData();
		formAccept.append("default_user", localStorage.getItem('default_user'))
		formAccept.append("invitation_id", id)
		formAccept.append("accept", "no")
		axios({
			method:'post',
			url: `${process.env.REACT_APP_API_URL}/company/private_certifer/accept_reject_invitation`,
			data: formAccept,
    		headers: { "Content-Type": "multipart/form-data" },
		})
		.then(res => {
				console.log(res)
			if(res?.data?.resultType == "S"){
				toast.success("Invitation Rejected")
				setReload(1)
			}
		})
		.catch(err => console.log(err))	
	}
	return(
		<>
		<Card className="mb-3">
      <FalconCardHeader title={title} />

      {loading ? <Loader/> : (
      <CardBody className="text-justify">
      		<Container className="hireRequestBody">
      		<Row className="p-2 table__head">
              <Col xs="1"><b>SNo.</b></Col>
              <Col xs="2"><b>Rec. Name</b></Col>
              <Col xs="2"><b>Company</b></Col>
              <Col xs="2"><b>Date</b></Col>
              <Col xs="3"><b>Status</b></Col>
              <Col xs="2"><b>Candidate</b></Col>
          </Row>
        
        {hirePendingReq !== null && 
        	hirePendingReq.length > 0 ? 
        		hirePendingReq?.map((req,index) => (
        		<Row key={index} className="p-2">
                	<Col xs="1">{index+1}</Col>
                	                	
                	                	<Col xs="2">
                	                		<Link to={{
                	                			pathname:`/page/${req.recruitment_company.id}`,
                	                			state:{
                	                				data:req.recruitment_company
                	                			}
                	                		}}>
                	                			{req.recruiter_profile.user_f_name ? req.recruiter_profile.user_f_name : null} {req.recruiter_profile.user_l_name ? req.recruiter_profile.user_l_name : null }
                	                		</Link>
                	                	</Col>
                	                	<Col xs="2">
                	                		<Link to={{
                	                			pathname:`/page/${req.recruitment_company.id}`,
                	                			state:{
                	                				data:req.recruitment_company
                	                				}
                	                			}}>
                	                			{req.recruitment_company.company_name ? req.recruitment_company.company_name : "NA"}
                	                		</Link>
                	                	</Col>

                	                	<Col xs="2">{moment(req.created_at).format('MM/DD/YYYY')}</Col>
                	                	{/*<Col xs="3">{req.status == null ? <Badge color="primary" pill>Pending</Badge> : req.status == 1 ? <Badge color="success" pill>Accepted</Badge> : <Badge color="danger" pill>Rejected</Badge>}</Col>
                	                	                	                	{req.status == 1 || req.status == 2 ? 
                	                	                	                		<Col xs="3">Responded</Col>
                	                	                	                		:
                	                	                	                		(<Col xs="2" className="buttonSection">
                	                	                	                		<Button className="buttonHire" color="success" size="sm" onClick={e => acceptHandler(req.id)}>Accept</Button>
                	                	                	                		<Button className="buttonHire" color="danger" size="sm" onClick={e => rejectHandler(req.id)}>Reject</Button>
                	                	                	                	</Col>)
                	                	                	                	}*/}
                	                	 {req.status == null || req.status == 0 ? 
                	                	 (<Col xs="3" className="buttonSection">
                	                	      <Button className="buttonHire" color="success" size="sm" onClick={e => acceptHandler(req.id)}>Accept</Button>
                	                	      <Button className="buttonHire" color="danger" size="sm" onClick={e => rejectHandler(req.id)}>Reject</Button>
                	                	  </Col>) : req.status == 1 ? <Col><Badge color="success"> Accepted</Badge></Col> : <Col><Badge color="danger"> Rejected</Badge></Col>}
                	                	 <Col xs="2">
                	                	 	<Button className="buttonHire" color="primary">View</Button>
                	                	 </Col>
                	
            	</Row>
        		)) : ( 
              <Row>
                <Col>
                  <Alert>No Data</Alert>
                </Col>
              </Row>)}
       	</Container>
      </CardBody>
      	)}
      	

      <CardFooter className="bg-light p-0 border-top">
        
      </CardFooter>
    </Card>
    <Associations/>
    </>
		)
}
export default HireRequest