import React, { Fragment, useEffect, useState, useContext } from 'react';
import PropTypes from 'prop-types';
import { isIterableArray } from '../../helpers/utils';
import { Card, CardBody, UncontrolledCollapse } from 'reactstrap';
import FalconCardHeader from '../common/FalconCardHeader';
import SkillSummary from './SkillSummary';
import Loader from '../common/Loader';
import SkillForm from './SkillForm';
import Flex from '../common/Flex';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
// import useFakeFetch from '../../hooks/useFakeFetch';
import axios from 'axios';
import {AllDetailsContext} from '../AllDetailsContext/AllDetailsContext'


const Skill = ({ educations: rawEducations, isEditable, ...rest }) => {
  // Data
  // const { loading: loadingEducations, data: educations, setData: setEducations } = useFakeFetch(rawEducations);
  const {setIsValueChange} = useContext(AllDetailsContext)
  
  const [skillData, setSkillData] = useState(null)
  const [loading, setLoading] = useState(true)
  const [isChange, setIsChange] = useState(false)

  function removeduplicates(arr){
    const uniqueIds = [];
    if(Array.isArray(arr)){
      // console.log('1',Array.isArray(arr))
      const unique = arr.filter(element => {
        const isDuplicate = uniqueIds.includes(element.id);
    
        if (!isDuplicate) {
          uniqueIds.push(element.id);
          return true;
        }
        return false;
        });
        return unique;
    }
    
  }

  useEffect(() => {
    const formBody = new FormData();
    formBody.append('user_id', localStorage.getItem('user_id'))
    axios({
      method:'post',
      url:`${process.env.REACT_APP_API_URL}/get_selected_skills`,
      data:formBody,
      headers: { "Content-Type": "multipart/form-data" },
    })
    .then(res => {
      // console.log(res,"this is skill data")
      if(res?.data?.status_code === 200) {
        // res.data.result.data.selected_skill = removeduplicates(res?.data?.result?.data.selected_skill)
        // console.log('profile skill',res?.data?.result?.data)
        setSkillData(res?.data?.result?.data)
        setLoading(false)
        setIsChange(false)
        setIsValueChange(true)
      }
    })
  },[isChange]);

  //     console.log(skillData,"===============")
  // console.log(isChange,"setIsChange")


  return (
    <>
      <FalconCardHeader title="Skill" />
      <CardBody className="fs--1">
        {isEditable && (
          <Fragment>
            <Flex align="center" className="mb-4 text-primary cursor-pointer fs-0" id="togglerAddEducation">
              <span className="circle-dashed">
                <FontAwesomeIcon icon="plus" />
              </span>
              <span className="ml-3">Add new skill</span>
            </Flex>
            <UncontrolledCollapse toggler="#togglerAddEducation">
          {/*educations={educations} setEducations={setEducations}*/}
              <SkillForm  setIsChange={setIsChange} label="Skill Categories"/>
              <hr className="border-dashed border-bottom-0 my-4" />
            </UncontrolledCollapse>
          </Fragment>
        )}
        {loading ? (
          <Loader />
        ) : (
            isIterableArray(skillData?.skill_category) &&
            skillData?.skill_category?.map((skill, index) => <SkillSummary {...skill} isEditable={isEditable} key={index} data={skillData}/>)
          )}
       {/* {loading ? (
          <Loader />
        ) : (
            isIterableArray(skillData?.selected_skill) &&
            skillData?.selected_skill?.map((sel_skill, index) => <SkillSummary {...sel_skill} isEditable={isEditable} key={index} />)
          )}*/}
      </CardBody>
    </>
  );
};

Skill.propTypes = {
  // educations: PropTypes.array,
  isEditable: PropTypes.bool
};

Skill.defaultProps = { isEditable: false };

export default Skill;

