import React,{useEffect, useState, useRef} from 'react';
// import SkillInput from './SkillInput'
import {Form, Col, FormGroup, Input, Label, Row, Button } from 'reactstrap';
import axios from 'axios';
import Multiselect from 'multiselect-react-dropdown';
import {toast} from 'react-toastify'

const SkillForm = ({setIsChange, label}) => {
	
	const [skillCategory, setSkillCategory] = useState(null);
	const [subCategory, setSubCategory] = useState(null);
	const [multiSelectList, setMultiSelectList] = useState(null);
	const [skill_id, setSkill_id] = useState("");
	const [sub_skill_id, setSubSkill_id] = useState([]);
	// const [skill, setSkill] = useState("");
  	const [isButtonDisable, setIsButtonDisable] = useState(true);
	const multiRef = useRef()
	// const singleInputRef = useRef(null)
	// const ev = singleInputRef?.current?.props?.onChange(e)
	// console.log(multiRef,"multiRef")

	useEffect(() => {
		const getSkills = async () => {
			const get = await axios.get(`${process.env.REACT_APP_API_URL}/skill_categories`)
			
			if(get?.data?.status_code === 200){
				setSkillCategory(get?.data?.result?.data?.skill_categories)
			}
		} 
		getSkills();
	},[])
	
	useEffect(() => {
		if (!skill_id || skill_id === "undefined") {
			console.warn("Invalid skill_id, skipping API call:", skill_id);
			return;
		}
		const getSubSkills = async () => {
			const get = await axios.get(`${process.env.REACT_APP_API_URL}/get_skills/${skill_id}`)
			// console.log(get,"sub skills")
			if(get?.data?.status_code === 200){
				setSubCategory(get?.data?.result?.data?.skill_categories)
			}
		} 
		getSubSkills();
	},[skill_id])

	useEffect(() => {
    setIsButtonDisable(
      !(
        skill_id &&
        multiSelectList &&
        subCategory
      )
    );
	// multiRef?.current?.state?.selectedValues = [];

  }, [subCategory, multiSelectList, skill_id]);
  
	
	// console.log(skillCategory,"qqqqqqqqqqqq")
	// console.log(subCategory,"sssssssssssss")
	// console.log(skill,"skill_id")
	
	const handleSubmit = e => {
		e.preventDefault();

		// console.log(multiSelectList)

		const formBody = new FormData();
		formBody.append('default_user', localStorage.getItem('default_user'))
		formBody.append('form_id', 'user_skill')
		formBody.append('skill_category_id', skill_id)
		formBody.append('skills', sub_skill_id.toString())
		axios({
			method:'post',
			url:`${process.env.REACT_APP_API_URL}/post/updateuserinfo`,
			data:formBody,
			headers: { "Content-Type": "multipart/form-data" },
		})
		.then(res => {
			// console.log(res)
			if(res?.data?.status_code === 200){
				toast.success("Skill Addedd!")
				multiRef.current.resetSelectedValues()
				setIsChange(true)
				setSkill_id('')
				setSubSkill_id([])
			}else{
				toast.success("Failed!")
			}
		})
		.catch(err => console.log(err))

		
	}


	const opts = [];
	const options = subCategory?.map(sub => {
		opts.push({
			name: sub.skill_name,
			id:sub.id	
		})
		
	})
	// console.log(opts,"=======================")

const onChangeSkill = e => {
	setMultiSelectList(null)
	setSkill_id(e.target.value)
	if(skill_id){
		multiRef.current.resetSelectedValues()
		setSubSkill_id([])
	}
	// multiRef?.current?.state?.selectedValues = [];
}
const onSelect = (selectedList, selectedItem) => {
	// console.log(selectedList,"selectedList")
	// console.log(selectedItem.id,"selectedItem")
	setMultiSelectList(selectedList)
	setSubSkill_id([...sub_skill_id, selectedItem.id])
}
// console.log(sub_skill_id,"id_str")

const onRemove = (selectedList, selectedItem) => {
	// console.log(selectedList,"removeList")
	// console.log(selectedItem,"removeitem")
	// setSubSkill_id(selectedList.id)
	
	const re = sub_skill_id.filter(sub_id => sub_id != selectedItem.id)
	setSubSkill_id(re)

	// console.log(re,"sssssssssssssssssssssssssssssss")
}

	// console.log(multiSelectList,"multiSelectList")
	return(
		<Form onSubmit={handleSubmit}>
			<FormGroup>
				<Row>
					<Col lg="3" className="text-lg-right">
						<Label className="mb-0">{label}</Label>
					</Col>
					<Col lg="9">
						<Input 
							type="select" 
							value={skill_id} 
							onChange={e => onChangeSkill(e)} 
							defaultValue="0"

							className="form-control-sm"
						>
							<option value="0">SELECT SKILL CATEGORY</option>
						{skillCategory?.map(category => (
							
							<option value={category.id} key={category.id}>{category.skill_name}</option>
							))}
						
						
						</Input>					
					</Col>
				</Row>
			</FormGroup>

			{subCategory && subCategory?.length > 0 && (
				
				<FormGroup>
				<Row>
					<Col lg="3" className="text-lg-right">
						<Label className="mb-0">Sub Categories</Label>
					</Col>
					<Col lg="9">
						{/*<Input type="select" value={skill} onChange={e => setSkill(e.target.value)} multiple>*/}
						{/*{subCategory?.map(sub => (
							<option value={sub.id} key={sub.id}>{sub.skill_name}</option>
							))}
						*/}
						{opts && 
							<Multiselect
								options={opts} // Options to display in the dropdown
								// selectedValues={this.state.selectedValue} // Preselected value to persist in dropdown
								onSelect={onSelect} // Function will trigger on select event
								onRemove={onRemove} // Function will trigger on remove event
								displayValue="name" // Property name to display in the dropdown options
								emptyRecordMsg="No record found!"
								placeholder="Select Sub Category"
								ref={multiRef}
								style={{
									searchBox: { 
										"border": "1px solid #d8e2ef", 
										"border-radius": ".25rem",
										"overflow":"scroll" 
									}
  								}}

								className="form-control-sm"
							/>
						}
						
						
						{/*</Input>					*/}
					</Col>
				</Row>
			</FormGroup>
			)}
			
			<FormGroup className="form-group">
        		<Row className="row">
          			<Col lg={{ size: 7, offset: 3 }}>
            			<Button 
            				color="primary" 
            				disabled={isButtonDisable}

							className="btn-sm"
            			>
              				Save
            			</Button>
          			</Col>
        		</Row>
      		</FormGroup>
			
		</Form>
		)
}
export default SkillForm;
