import React from 'react';
import PropTypes from 'prop-types';
import { Button, Media, Row, Col } from 'reactstrap';
import { Link } from 'react-router-dom';
import Verified from '../common/Verified';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import Avatar from '../common/Avatar';
// { imgSrc, institution, degree, duration, location, divider, verified, isEditable, to }
const SkillSummary = (props) => {
  console.log(props,"propsssssssssssssssssss")
  return(
    <div>
      <h6>{props.type == "category" ? props.skill_name : null}</h6>
      {props.data.selected_skill.map(skill => (
          <ul>
            <li>{skill.skill_name}</li>
          </ul>
        ))}
      
    </div>
  )};

SkillSummary.propTypes = {
  imgSrc: PropTypes.string.isRequired,
  institution: PropTypes.string.isRequired,
  degree: PropTypes.string.isRequired,
  duration: PropTypes.string.isRequired,
  location: PropTypes.string.isRequired,
  to: PropTypes.string.isRequired,
  divider: PropTypes.bool,
  verified: PropTypes.bool,
  isEditable: PropTypes.bool
};

SkillSummary.defaultProps = {
  divider: true,
  verified: false
};

export default SkillSummary;
