import { useEffect, useState } from "react";
import config from "../helpers/config";
import axios from 'axios';

const usePostFetch = (api, obj) => {
  const [loading, setLoading] = useState(true);
  const [data, setData] = useState(null);
  let isMounted = true;
  let url_api = config.API_URL() + api;
  useEffect(() => {
    axios({
      method: 'post',
      url: url_api,
      data: obj,
      headers: {
        'Content-Type': 'application/json'
        }, 
      })
      // .then((response) => response.json())
      .then((data) => {
        if (isMounted) {
          setData(data);
          setLoading(false);
        }
      });
    return () => (isMounted = false);
  }, [api]);

  return { loading, setLoading, data, setData };
};

export default usePostFetch;
